/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartTank;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;

public abstract class PartEngine
extends Part {
    protected Supplier<Float> maxSpeed;
    protected Supplier<Float> maxReverseSpeed;
    protected Supplier<Float> acceleration;
    protected Supplier<Float> fuelEfficiency;

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    public float getMaxSpeed() {
        return this.maxSpeed.get().floatValue();
    }

    public float getMaxReverseSpeed() {
        return this.maxReverseSpeed.get().floatValue();
    }

    public float getAcceleration() {
        return this.acceleration.get().floatValue();
    }

    public float getFuelEfficiency() {
        return this.fuelEfficiency.get().floatValue();
    }

    @Override
    public boolean validate(List<Part> parts, List<Component> messages) {
        if (PartEngine.getAmount(parts, part -> part instanceof PartTank) > 1) {
            messages.add((Component)new TranslatableComponent("message.parts.too_many_tanks"));
        } else if (PartEngine.getAmount(parts, part -> part instanceof PartTank) <= 0) {
            messages.add((Component)new TranslatableComponent("message.parts.no_tank"));
        }
        return super.validate(parts, messages);
    }
}

